#include "stdafx.h"
#include "UserModule.h"
#include "SilkModuleDlg.h"
#include "DataCenter.h"
CUserModule::CUserModule( IMsgListener *pListener, CThreadBase *pThread )
: m_pListener(pListener)
, m_pThread(pThread)
, m_year(0)
, m_month(0)
, m_day(0)
, m_hour(0)
, m_min(0)
, m_sec(0)
, m_result(0)
, m_pResListerner(NULL)
{
	m_hEvent = CreateEvent(NULL, TRUE, FALSE, 0);
}

CUserModule::~CUserModule()
{

}

void CUserModule::HeartBeat_Imp()
{
	m_queMutex.acquire();
	int size = m_pduQueue.size();
	if (size == 0)
	{
		m_queMutex.release();
		return;
	}
	CInterProtocl *pdu = m_pduQueue.front();
	m_pduQueue.pop_front();
	m_queMutex.release();

	switch (pdu->m_eventType)
	{
	case EVENT_REQUEST:
		{
			DealOneRequestMsg(pdu);
		}
		break;
	case EVENT_RESPONSE:
		{
			DealOneResponseMsg(pdu);
		}
		break;
	case EVENT_NOTICE:
		{
			switch (pdu->m_operation)
			{
			case NOTICE_IDENTIFY:
				{
					m_pResListerner->onResult(pdu->m_Reslut, pdu->m_operation, pdu->m_data, pdu->m_len, pdu->m_nParam1, pdu->m_nParam2, pdu->m_nParam3);
					/*CString str;
					str.Format("ID:%d", pdu->m_nParam1);*/
					//m_pDlg->GetDlgItem(IDC_STATIC_STATE)->SetWindowText(str);

				}
				break;
			/*case OP_READ_USER:
				{
					PUser user = (PUser)pdu->m_data;
					CString str;
					str.Format("OP_READ_USER\r\npin=%d\r\nname=%s\r\n", user->PIN, user->Name);
					SetText(pdu, str);
				}
				break;*/
			}
		}
		break;
	}
	pdu->recycleITP();
	//CDataCenter::GetInstance()->recycleITP(pdu);
}

void CUserModule::DealOneRequestMsg( CInterProtocl *pITP )
{

}

void CUserModule::DealOneResponseMsg( CInterProtocl *pITP )
{
	if (pITP->m_operation == OP_SCAN_IMAGE && pITP->m_Reslut == Result_OK)
	{
		CInterProtocl *pdu = CDataCenter::GetInstance()->GetITP();
		if (pdu == NULL)
		{
			return;
		}
		pdu->m_eventType = EVENT_NOTICE;
		pdu->m_srcModule = USER_MODULE;
		pdu->m_desModule = USER_MODULE;
		pdu->m_operation = pITP->m_operation;
		pdu->m_Reslut = pITP->m_Reslut;
		pdu->m_nParam1 = pITP->m_nParam1;
		pdu->m_nParam2 = pITP->m_nParam2;
		pdu->m_nParam3 = pITP->m_nParam3;
		if (pITP->m_len != 0)
		{
			pdu->PushData(pITP->m_data, pITP->m_len);
		}
		m_pThread->pushMsg(pdu);
		//writeBitmap("www.bmp", pITP->m_data, pITP->m_nParam1, pITP->m_nParam2);
	}
	SetResult(pITP);
	if (m_pResListerner != NULL)
	{
		if (pITP->m_lenEx != 0)
		{
			m_pResListerner->onResult(pITP->m_Reslut, pITP->m_operation, pITP->m_dataEx, pITP->m_lenEx, pITP->m_nParam1, pITP->m_nParam2, pITP->m_nParam3);
		}
		else
		{
			m_pResListerner->onResult(pITP->m_Reslut, pITP->m_operation, pITP->m_data, pITP->m_len, pITP->m_nParam1, pITP->m_nParam2, pITP->m_nParam3);
		}
	}
}

bool CUserModule::connect(int connectType)
{
	CInterProtocl *pITP = CDataCenter::GetInstance()->GetITP();
	if (pITP == NULL)
	{
		return false;
	}
	pITP->m_eventType = EVENT_REQUEST;
	pITP->m_srcModule = USER_MODULE;
	pITP->m_desModule = USB_MODULE;
	pITP->m_operation = OP_CONNECT;
	pITP->m_nParam1 = connectType;
	m_pListener->onMsgPdu(pITP);
	return WaitResult();
}

bool CUserModule::disConnect()
{
	CInterProtocl *pITP = CDataCenter::GetInstance()->GetITP();
	if (pITP == NULL)
	{
		return false;
	}
	pITP->m_eventType = EVENT_REQUEST;
	pITP->m_srcModule = USER_MODULE;
	pITP->m_desModule = USB_MODULE;
	pITP->m_operation = OP_DIS_CONNECT;
	m_pListener->onMsgPdu(pITP);
	return WaitResult();
}

bool CUserModule::enroll( int pin,int flag )
{
	CInterProtocl *pITP = CDataCenter::GetInstance()->GetITP();
	if (pITP == NULL)
	{
		return false;
	}
	pITP->m_eventType = EVENT_REQUEST;
	pITP->m_srcModule = USER_MODULE;
	pITP->m_desModule = USB_MODULE;
	pITP->m_operation = OP_ENROLL;
	pITP->m_nParam1 = pin;
	pITP->m_nParam2 = flag;
	m_pListener->onMsgPdu(pITP);

	return WaitResult();
}

void CUserModule::startReadData()
{
	CInterProtocl *pITP = CDataCenter::GetInstance()->GetITP();
	if (pITP == NULL)
	{
		return;
	}
	pITP->m_eventType = EVENT_REQUEST;
	pITP->m_srcModule = USER_MODULE;
	pITP->m_desModule = USB_MODULE;
	pITP->m_operation = OP_START_READ_DATA;
	m_pListener->onMsgPdu(pITP);
}

void CUserModule::stopReadData()
{
	CInterProtocl *pITP = CDataCenter::GetInstance()->GetITP();
	if (pITP == NULL)
	{
		return;
	}
	pITP->m_eventType = EVENT_REQUEST;
	pITP->m_srcModule = USER_MODULE;
	pITP->m_desModule = USB_MODULE;
	pITP->m_operation = OP_STOP_READ_DATA;
	m_pListener->onMsgPdu(pITP);
}

bool CUserModule::testProtocol()
{
	connect(1);
	CInterProtocl *pITP = CDataCenter::GetInstance()->GetITP();
	pITP->m_eventType = EVENT_REQUEST;
	pITP->m_srcModule = USER_MODULE;
	pITP->m_desModule = USB_MODULE;
	pITP->m_operation = OP_DEL_TMP;
	pITP->m_nParam1 = 2424;
	m_pListener->onMsgPdu(pITP);

	pITP = CDataCenter::GetInstance()->GetITP();
	pITP->m_eventType = EVENT_REQUEST;
	pITP->m_srcModule = USER_MODULE;
	pITP->m_desModule = USB_MODULE;
	pITP->m_operation = OP_DEL_TMP;
	m_pListener->onMsgPdu(pITP);

	pITP = CDataCenter::GetInstance()->GetITP();
	pITP->m_eventType = EVENT_REQUEST;
	pITP->m_srcModule = USER_MODULE;
	pITP->m_desModule = USB_MODULE;
	pITP->m_operation = OP_DEL_DB;
	m_pListener->onMsgPdu(pITP);

	pITP = CDataCenter::GetInstance()->GetITP();
	pITP->m_eventType = EVENT_REQUEST;
	pITP->m_srcModule = USER_MODULE;
	pITP->m_desModule = USB_MODULE;
	pITP->m_operation = OP_DEL_DB;
	m_pListener->onMsgPdu(pITP);
	return true;
}

bool CUserModule::enrollByImage( char *image, int len, int pin )
{
	//writeBitmap("data11.bmp", image, 276, 375);
	CInterProtocl *pITP = CDataCenter::GetInstance()->GetITP();
	if (pITP == NULL)
	{
		return false;
	}
	pITP->m_eventType = EVENT_REQUEST;
	pITP->m_srcModule = USER_MODULE;
	pITP->m_desModule = USB_MODULE;
	pITP->m_operation = OP_ENROLL_IMAGE;

	pITP->m_nParam1 = pin;
	int d = pITP->PushData(image, len);

	m_pListener->onMsgPdu(pITP);

	return WaitResult();
}

bool CUserModule::deleteUser( int pin /*= 0*/ )
{
	CInterProtocl *pITP = CDataCenter::GetInstance()->GetITP();
	if (pITP == NULL)
	{
		return false;
	}
	pITP->m_eventType = EVENT_REQUEST;
	pITP->m_srcModule = USER_MODULE;
	pITP->m_desModule = USB_MODULE;
	pITP->m_operation = OP_DEL_USER;
	pITP->m_nParam1 = pin;
	m_pListener->onMsgPdu(pITP);

	return WaitResult();
}

bool CUserModule::deleteTmp( int pin /*= 0*/ )
{
	CInterProtocl *pITP = CDataCenter::GetInstance()->GetITP();
	if (pITP == NULL)
	{
		return false;
	}
	pITP->m_eventType = EVENT_REQUEST;
	pITP->m_srcModule = USER_MODULE;
	pITP->m_desModule = USB_MODULE;
	pITP->m_operation = OP_DEL_TMP;
	pITP->m_nParam1 = pin;
	m_pListener->onMsgPdu(pITP);

	return WaitResult();
}

bool CUserModule::deleteDB()
{
	CInterProtocl *pITP = CDataCenter::GetInstance()->GetITP();
	if (pITP == NULL)
	{
		return false;
	}
	pITP->m_eventType = EVENT_REQUEST;
	pITP->m_srcModule = USER_MODULE;
	pITP->m_desModule = USB_MODULE;
	pITP->m_operation = OP_DEL_DB;
	m_pListener->onMsgPdu(pITP);

	return WaitResult();
}

bool CUserModule::scanFpImage()
{
	CInterProtocl *pITP = CDataCenter::GetInstance()->GetITP();
	if (pITP == NULL)
	{
		return false;
	}
	pITP->m_eventType = EVENT_REQUEST;
	pITP->m_srcModule = USER_MODULE;
	pITP->m_desModule = USB_MODULE;
	pITP->m_operation = OP_SCAN_IMAGE;
	m_pListener->onMsgPdu(pITP);
	
	return WaitResult();
}

void CUserModule::writeBitmap( char *imgout, char *buffer, int nWidth, int nHeight )
{
	BITMAPFILEHEADER bfh;
	RGBQUAD* m_lpvColorTable;
	BITMAPINFOHEADER *m_lpBMIH;

	int m_nColorTableEntries=256;
	int m_nBitCount=8;

	FILE *fo;
	int i;

	if((fo = fopen(imgout, "w+b")) == NULL)
	{
		return;
	}

	m_lpBMIH = (BITMAPINFOHEADER*) malloc(sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * m_nColorTableEntries);
	m_lpBMIH->biSize = sizeof(BITMAPINFOHEADER);
	m_lpBMIH->biWidth  = nWidth;
	m_lpBMIH->biHeight = nHeight;
	m_lpBMIH->biPlanes = 1;
	m_lpBMIH->biBitCount = m_nBitCount;
	m_lpBMIH->biCompression = 0;
	m_lpBMIH->biSizeImage = 0;
	m_lpBMIH->biXPelsPerMeter = 0;
	m_lpBMIH->biYPelsPerMeter = 0;
	m_lpBMIH->biClrUsed      = m_nColorTableEntries;
	m_lpBMIH->biClrImportant = m_nColorTableEntries;

	m_lpvColorTable = (RGBQUAD*)((unsigned char *)m_lpBMIH + sizeof(BITMAPINFOHEADER)); // points inside m_lpBMIH.
	for (i = 0; i < m_nColorTableEntries; i++)
	{
		BYTE k = m_nColorTableEntries==256?(BYTE)i:(BYTE)i<<4;

		m_lpvColorTable[i].rgbRed      = k;  // Gray Scale !
		m_lpvColorTable[i].rgbGreen    = k;
		m_lpvColorTable[i].rgbBlue     = k;
		m_lpvColorTable[i].rgbReserved = 0;
	}

	// Fill in the Bitmap File Header
	memset(&bfh, 0, sizeof(BITMAPFILEHEADER));
	bfh.bfType = ( (WORD) ('M' << 8) | 'B');

	// Calculate the size of the bitmap including the palette
	bfh.bfSize = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) +
		m_lpBMIH->biClrUsed * sizeof(RGBQUAD) +
		((((m_lpBMIH->biWidth * m_lpBMIH->biBitCount + 31)/32) * 4) * m_lpBMIH->biHeight);
	bfh.bfReserved1 = 0;
	bfh.bfReserved2 = 0;

	// Offset to actual bits is after palette
	bfh.bfOffBits = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER)
		+ m_lpBMIH->biClrUsed * sizeof(RGBQUAD);

	// Write the results
	int Length1=0,Length2=0;
	Length1=sizeof(BITMAPFILEHEADER);
	fwrite(&bfh, sizeof(BITMAPFILEHEADER), 1, fo);
	fwrite(m_lpBMIH, sizeof(BITMAPINFOHEADER)+m_lpBMIH->biClrUsed*sizeof(RGBQUAD), 1, fo);
	Length2=sizeof(BITMAPINFOHEADER)+m_lpBMIH->biClrUsed*sizeof(RGBQUAD);


	///*
	int tmp=0;
	char* TmpBuf =new char[nWidth];
	char *p;

	tmp=(nHeight-1)*nWidth;
	for(i=0;i<nHeight;i++)
	{
		p=buffer+tmp;
		fwrite(buffer+tmp,nWidth , 1, fo);
		tmp-=nWidth;
	}

	delete TmpBuf;
	//*/
	//fwrite(buffer, bfh.bfSize-sizeof(BITMAPFILEHEADER)-sizeof(BITMAPINFOHEADER)-m_lpBMIH->biClrUsed*sizeof(RGBQUAD), 1, fo);

	free(m_lpBMIH);

	fclose(fo);
}

bool CUserModule::setTime( int year, int month, int day, int hour, int min, int sec )
{
	CInterProtocl *pITP = CDataCenter::GetInstance()->GetITP();
	if (pITP == NULL)
	{
		return false;
	}
	pITP->m_eventType = EVENT_REQUEST;
	pITP->m_srcModule = USER_MODULE;
	pITP->m_desModule = USB_MODULE;
	pITP->m_operation = OP_SET_TIME;

	int date = 0;
	int time = 0;
	date |= (day & 0xFF);
	date <<= 8;
	date |= (month & 0xFF);
	date <<= 8;
	year -= 2000;
	date |= (year & 0xFF);

	time |= (sec & 0xFF);
	time <<= 8;
	time |= (min & 0xFF);
	time <<= 8;
	time |= (hour & 0xFF);

	pITP->m_nParam1 = date;
	pITP->m_nParam2 = time;

	m_pListener->onMsgPdu(pITP);

	return WaitResult();
}

bool CUserModule::getTime( int &year, int &month, int &day, int &hour, int &min, int &sec )
{
	CInterProtocl *pITP = CDataCenter::GetInstance()->GetITP();
	if (pITP == NULL)
	{
		return false;
	}
	pITP->m_eventType = EVENT_REQUEST;
	pITP->m_srcModule = USER_MODULE;
	pITP->m_desModule = USB_MODULE;
	pITP->m_operation = OP_GET_TIME;
	m_pListener->onMsgPdu(pITP);

	if (m_pResListerner != NULL)
	{
		return true;
	}
	ResetEvent(m_hEvent);
	if (WaitForSingleObject(m_hEvent, 3000) != WAIT_OBJECT_0)
	{
		return false;
	}
	if (m_result == 0)
	{
		return false;
	}

	int date = 0;
	int time = 0;
	memcpy(&date, m_tmp, m_tmpLen1);
	memcpy(&time, m_tmp+m_tmpLen1, m_tmpLen2);

	year = (date & 0xFF) + 2000;
	date >>= 8;
	month = date & 0xFF;
	date >>= 8;
	day = date & 0xFF;

	hour = time & 0xFF;
	time >>= 8;
	min = time & 0xFF;
	time >>= 8;
	sec = time & 0xFF;

	/*year = m_year;
	month = m_month;
	day = m_day;

	hour = m_hour;
	min  = m_min;
	sec = m_sec;*/
	return true;
}

bool CUserModule::readParam()
{
	CInterProtocl *pITP = CDataCenter::GetInstance()->GetITP();
	if (pITP == NULL)
	{
		return false;
	}
	pITP->m_eventType = EVENT_REQUEST;
	pITP->m_srcModule = USER_MODULE;
	pITP->m_desModule = USB_MODULE;
	pITP->m_operation = OP_SYS_READ_PARAM;
	m_pListener->onMsgPdu(pITP);

	return WaitResult();
}

bool CUserModule::writeParam(SetParam &param)
{
	CInterProtocl *pITP = CDataCenter::GetInstance()->GetITP();
	if (pITP == NULL)
	{
		return false;
	}
	pITP->m_eventType = EVENT_REQUEST;
	pITP->m_srcModule = USER_MODULE;
	pITP->m_desModule = USB_MODULE;
	pITP->m_operation = OP_SYS_WRITE_PARAM;
	pITP->PushData((char*)&param, sizeof(SetParam));
	m_pListener->onMsgPdu(pITP);

	return WaitResult();
}

bool CUserModule::addUser( TUser &user )
{
	CInterProtocl *pITP = CDataCenter::GetInstance()->GetITP();
	if (pITP == NULL)
	{
		return false;
	}
	pITP->m_eventType = EVENT_REQUEST;
	pITP->m_srcModule = USER_MODULE;
	pITP->m_desModule = USB_MODULE;
	pITP->m_operation = OP_ADD_USER;
	pITP->PushData((char *)&user, sizeof(user));
	m_pListener->onMsgPdu(pITP);

	return WaitResult();
}

bool CUserModule::readUser( int pin, TUser &user )
{
	CInterProtocl *pITP = CDataCenter::GetInstance()->GetITP();
	if (pITP == NULL)
	{
		return false;
	}
	pITP->m_eventType = EVENT_REQUEST;
	pITP->m_srcModule = USER_MODULE;
	pITP->m_desModule = USB_MODULE;
	pITP->m_operation = OP_READ_USER;
	pITP->m_nParam1 = pin;
	m_pListener->onMsgPdu(pITP);

	return WaitResult();
}

bool CUserModule::loadUser()
{
	CInterProtocl *pITP = CDataCenter::GetInstance()->GetITP();
	if (pITP == NULL)
	{
		return false;
	}
	pITP->m_eventType = EVENT_REQUEST;
	pITP->m_srcModule = USER_MODULE;
	pITP->m_desModule = USB_MODULE;
	pITP->m_operation = OP_LOAD_USER;
	m_pListener->onMsgPdu(pITP);
	
	return WaitResult();
}

bool CUserModule::enrollTmp( int pin, char *tmp, int len )
{
	CInterProtocl *pITP = CDataCenter::GetInstance()->GetITP();
	if (pITP == NULL)
	{
		return false;
	}
	pITP->m_eventType = EVENT_REQUEST;
	pITP->m_srcModule = USER_MODULE;
	pITP->m_desModule = USB_MODULE;
	pITP->m_operation = OP_ENROLL_TMP;
	pITP->m_nParam1 = pin;
	pITP->PushData(tmp, len);
	m_pListener->onMsgPdu(pITP);

	return WaitResult();
}

bool CUserModule::loadTmp()
{
	CInterProtocl *pITP = CDataCenter::GetInstance()->GetITP();
	if (pITP == NULL)
	{
		return false;
	}
	pITP->m_eventType = EVENT_REQUEST;
	pITP->m_srcModule = USER_MODULE;
	pITP->m_desModule = USB_MODULE;
	pITP->m_operation = OP_LOAD_TMP;
	m_pListener->onMsgPdu(pITP);

	return WaitResult();
}

void CUserModule::SetResult( CInterProtocl *pITP )
{
	if (pITP->m_Reslut == Result_OK)
	{
		m_result = 1;
	}
	else
	{
		m_result = 0;
	}
	if (m_pResListerner == NULL)
	{
		SetEvent(m_hEvent);
	}
}

bool CUserModule::saveParam()
{
	CInterProtocl *pITP = CDataCenter::GetInstance()->GetITP();
	if (pITP == NULL)
	{
		return false;
	}
	pITP->m_eventType = EVENT_REQUEST;
	pITP->m_srcModule = USER_MODULE;
	pITP->m_desModule = USB_MODULE;
	pITP->m_operation = OP_SYS_SAVE_PARAM;
	m_pListener->onMsgPdu(pITP);

	return WaitResult();
}

bool CUserModule::delLog()
{
	CInterProtocl *pITP = CDataCenter::GetInstance()->GetITP();
	if (pITP == NULL)
	{
		return false;
	}
	pITP->m_eventType = EVENT_REQUEST;
	pITP->m_srcModule = USER_MODULE;
	pITP->m_desModule = USB_MODULE;
	pITP->m_operation = OP_DEL_LOG;
	m_pListener->onMsgPdu(pITP);

	return WaitResult();
}

bool CUserModule::loadLog()
{
	CInterProtocl *pITP = CDataCenter::GetInstance()->GetITP();
	if (pITP == NULL)
	{
		return false;
	}
	pITP->m_eventType = EVENT_REQUEST;
	pITP->m_srcModule = USER_MODULE;
	pITP->m_desModule = USB_MODULE;
	pITP->m_operation = OP_LOAD_LOG;
	m_pListener->onMsgPdu(pITP);

	return WaitResult();
}

bool CUserModule::verifyFp( int pin )
{
	CInterProtocl *pITP = CDataCenter::GetInstance()->GetITP();
	if (pITP == NULL)
	{
		return false;
	}
	pITP->m_eventType = EVENT_REQUEST;
	pITP->m_srcModule = USER_MODULE;
	pITP->m_desModule = USB_MODULE;
	pITP->m_operation = OP_VERIFY;
	pITP->m_nParam1 = pin;
	m_pListener->onMsgPdu(pITP);

	return WaitResult();
}

bool CUserModule::verifyFp( char *image, int len )
{
	CInterProtocl *pITP = CDataCenter::GetInstance()->GetITP();
	if (pITP == NULL)
	{
		return false;
	}
	pITP->m_eventType = EVENT_REQUEST;
	pITP->m_srcModule = USER_MODULE;
	pITP->m_desModule = USB_MODULE;
	pITP->m_operation = OP_VERIFY;
	pITP->PushData(image, len);
	m_pListener->onMsgPdu(pITP);

	return WaitResult();
}

bool CUserModule::readTmp( int pin )
{
	CInterProtocl *pITP = CDataCenter::GetInstance()->GetITP();
	if (pITP == NULL)
	{
		return false;
	}
	pITP->m_eventType = EVENT_REQUEST;
	pITP->m_srcModule = USER_MODULE;
	pITP->m_desModule = USB_MODULE;
	pITP->m_operation = OP_READ_TMP;
	pITP->m_nParam1 = pin;
	m_pListener->onMsgPdu(pITP);

	return WaitResult();
}

bool CUserModule::updata( char *data, int len )
{
	CInterProtocl *pITP = CDataCenter::GetInstance()->GetITP();
	if (pITP == NULL)
	{
		return false;
	}
	pITP->m_eventType = EVENT_REQUEST;
	pITP->m_srcModule = USER_MODULE;
	pITP->m_desModule = USB_MODULE;
	pITP->m_operation = OP_UPDATA;
	if (pITP->PushData(data, len) == 0)
	{
		return false;
	}
	m_pListener->onMsgPdu(pITP);
	return WaitResult();
}

//bool CUserModule::setCallback( MsgFunc cbFunc, void *param )
//{
//	m_cbMsgFunc = cbFunc;
//	m_pUserData = param;
//	return true;
//}

bool CUserModule::WaitResult()
{
	if (m_pResListerner == NULL)
	{
		ResetEvent(m_hEvent);
		if (WaitForSingleObject(m_hEvent, 30000) != WAIT_OBJECT_0)
		{
			return false;
		}
		if (m_result == 0)
		{
			return false;
		}
	}
	return true;
}

bool CUserModule::setResultListerner( IResultListener *pListerner )
{
	m_pResListerner = pListerner;
	return true;
}

bool CUserModule::scanTmp()
{
	CInterProtocl *pITP = CDataCenter::GetInstance()->GetITP();
	if (pITP == NULL)
	{
		return false;
	}
	pITP->m_eventType = EVENT_REQUEST;
	pITP->m_srcModule = USER_MODULE;
	pITP->m_desModule = USB_MODULE;
	pITP->m_operation = OP_SCAN_TMP;
	m_pListener->onMsgPdu(pITP);
	return WaitResult();
}
bool CUserModule::reset()
{
	CInterProtocl *pITP = CDataCenter::GetInstance()->GetITP();
	if (pITP == NULL)
	{
		return false;
	}
	pITP->m_eventType = EVENT_REQUEST;
	pITP->m_srcModule = USER_MODULE;
	pITP->m_desModule = USB_MODULE;
	pITP->m_operation = OP_RESET;
	m_pListener->onMsgPdu(pITP);
	return WaitResult();
}
